/**
  ******************************************************************************
  * @file    cp_taghelper.c 
  * @author  Ruediger R. Asche
  * @version V1.0.0
  * @date    July 14, 2016
  * @brief   utility functions that deal with TLV telegrams
  ******************************************************************************
  * @attention
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, THE AUTHOR SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  ******************************************************************************  
  */ 

#include "project.h"

#include "cp.h"

/** @brief Creates a dynamic (chained) TLV structure from TLV elements
 *
 * 
 *  @param p_Tag Tag
 *  @param p_Len Length
 *  @param p_Val Value
 *  @param p_Processor communication processor
 *  @param p_DynTagStruct (output parameter) receiver of allocated structure
 *
 *  @return status code (see CP_STATUSCODE_XXX enumerator in cp_frame.h)
 *
 */

CP_STATUSCODE cp_DynTagFromTLV(unsigned long p_Tag, unsigned long p_Len,unsigned char *p_Val,CP_DYNTAGSTRUCT **p_DynTagStruct)
{
    PCP_DYNTAGSTRUCT a_Result = (PCP_DYNTAGSTRUCT)pvPortMalloc(sizeof(CP_DYNTAGSTRUCT)+(p_Len-1));
    if (!a_Result)
        return CP_STATUSCODE_NOMEM;
    a_Result->m_Next = 0;
    a_Result->m_Tag = p_Tag;
    a_Result->m_Len = p_Len;
    memcpy(&a_Result->m_MarshalledVal,p_Val,p_Len);
    *p_DynTagStruct = a_Result;
    return CP_STATUSCODE_SUCCESS;    
}

/** @brief Appends a dynamic (chained) TLV structure to an exisiting chain
 *
 * 
 *  @param p_DynTagStruct chain to append element to
 *  @param p_NewDynTagPtr Element to append to chain
 *
 *  @return none
 *
 */

void cp_InsertDynTagAtEnd(CP_DYNTAGSTRUCT **p_DynTagStruct,CP_DYNTAGSTRUCT *p_NewDynTagPtr)
{
    CP_DYNTAGSTRUCT **a_Next = p_DynTagStruct;
    while (*a_Next)
        a_Next = &(*a_Next)->m_Next;
    *a_Next = p_NewDynTagPtr;     
}            

/** @brief Deletes a dynamic (chained) TLV structure
 *
 * 
 *  @param p_DynTagStruct chain to delete
 *
 *  @return none
 *
 */

void cp_DeleteTagChain(CP_DYNTAGSTRUCT **p_DynTagStruct)
{
    CP_DYNTAGSTRUCT *a_Next = *p_DynTagStruct;
    while (a_Next)
    {
        CP_DYNTAGSTRUCT *a_Temp = a_Next->m_Next;
        vPortFree(a_Next);
        a_Next = a_Temp;
    }
}
